<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldsToInterviewToolsTable extends Migration
{
    public function up()
    {
        Schema::table('interview_tools', function (Blueprint $table) {
            $table->unsignedBigInteger('Question_set_id')->nullable()->after('User_id');
            $table->enum('Tool_type', ['mock_interview', 'practice_test'])->default('mock_interview')->after('Question_set_id');
            $table->longText('Config')->nullable()->after('Tool_type');

            $table->foreign('Question_set_id')
                  ->references('Question_id')
                  ->on('exam_questions')
                  ->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::table('interview_tools', function (Blueprint $table) {
            $table->dropForeign(['Question_set_id']);
            $table->dropColumn(['Question_set_id', 'Tool_type', 'Config']);
        });
    }
}
?>
